<?php
require_once '../config/db.php';
require_once '../includes/functions.php';

checkAuth();

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $search = $_GET['search'] ?? '';
    $category = $_GET['category'] ?? 'all';

    $sql = "SELECT * FROM products WHERE 1=1";
    $params = [];

    if (!empty($search)) {
        $sql .= " AND (name LIKE ? OR description LIKE ?)";
        $params[] = "%$search%";
        $params[] = "%$search%";
    }

    if ($category !== 'all') {
        $sql .= " AND category = ?";
        $params[] = $category;
    }

    $sql .= " ORDER BY created_at DESC";

    $stmt = $pdo->prepare($sql);
    $stmt->execute($params);
    $products = $stmt->fetchAll();

    // Decode images JSON for frontend
    foreach ($products as &$product) {
        $product['images'] = json_decode($product['images']);
    }

    jsonResponse(true, $products);
}

if ($method === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);

    // Basic validation
    if (empty($data['name']) || empty($data['price']) || !isset($data['stock'])) {
        jsonResponse(false, [], 'Missing required fields');
    }

    $sql = "INSERT INTO products (name, description, price, stock, category, size, images) VALUES (?, ?, ?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);

    try {
        $stmt->execute([
            $data['name'],
            $data['description'] ?? '',
            $data['price'],
            $data['stock'],
            $data['category'] ?? 'Snapback',
            $data['size'] ?? '',
            json_encode($data['images'] ?? [])
        ]);
        jsonResponse(true, ['id' => $pdo->lastInsertId()], 'Product created successfully');
    } catch (PDOException $e) {
        jsonResponse(false, [], $e->getMessage());
    }
}

if ($method === 'PUT') {
    $data = json_decode(file_get_contents('php://input'), true);

    if (empty($data['id'])) {
        jsonResponse(false, [], 'Product ID required');
    }

    $sql = "UPDATE products SET name=?, description=?, price=?, stock=?, category=?, size=?, images=? WHERE id=?";
    $stmt = $pdo->prepare($sql);

    try {
        $stmt->execute([
            $data['name'],
            $data['description'] ?? '',
            $data['price'],
            $data['stock'],
            $data['category'] ?? 'Snapback',
            $data['size'] ?? '',
            json_encode($data['images'] ?? []),
            $data['id']
        ]);
        jsonResponse(true, [], 'Product updated successfully');
    } catch (PDOException $e) {
        jsonResponse(false, [], $e->getMessage());
    }
}

if ($method === 'DELETE') {
    $id = $_GET['id'] ?? 0;

    if (!$id) {
        jsonResponse(false, [], 'Product ID required');
    }

    $stmt = $pdo->prepare("DELETE FROM products WHERE id = ?");
    try {
        $stmt->execute([$id]);
        jsonResponse(true, [], 'Product deleted successfully');
    } catch (PDOException $e) {
        jsonResponse(false, [], $e->getMessage());
    }
}
?>