<?php
require_once '../config/db.php';
require_once '../includes/functions.php';

checkAuth();

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $sql = "SELECT s.*, u.name as seller_name FROM sales s JOIN users u ON s.seller_id = u.id ORDER BY s.created_at DESC";
    $stmt = $pdo->query($sql);
    $sales = $stmt->fetchAll();

    // For each sale, get items if needed, or just return summary
    // Let's return items too for detail view handling if we have time
    foreach ($sales as &$sale) {
        $stmtItems = $pdo->prepare("SELECT si.*, p.name as product_name FROM sale_items si JOIN products p ON si.product_id = p.id WHERE sale_id = ?");
        $stmtItems->execute([$sale['id']]);
        $sale['items'] = $stmtItems->fetchAll();
    }

    jsonResponse(true, $sales);
}

if ($method === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);

    // Validate
    if (empty($data['items']) || !is_array($data['items'])) {
        jsonResponse(false, [], 'Cart is empty');
    }

    $pdo->beginTransaction();

    try {
        $total = 0;
        foreach ($data['items'] as $item) {
            $total += $item['price'] * $item['quantity'];

            // Check stock
            $stmt = $pdo->prepare("SELECT stock FROM products WHERE id = ?");
            $stmt->execute([$item['productId']]);
            $currentStock = $stmt->fetchColumn();

            if ($currentStock < $item['quantity']) {
                throw new Exception("Insufficient stock for product ID " . $item['productId']);
            }
        }

        // Create Sale
        $stmt = $pdo->prepare("INSERT INTO sales (total, type, payment_method, seller_id, status) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([
            $total,
            'LOCAL',
            $data['paymentMethod'] ?? 'EFECTIVO',
            $_SESSION['user_id'],
            'COMPLETED'
        ]);
        $saleId = $pdo->lastInsertId();

        // Create Sale Items and Update Stock
        $stmtItem = $pdo->prepare("INSERT INTO sale_items (sale_id, product_id, quantity, price) VALUES (?, ?, ?, ?)");
        $stmtStock = $pdo->prepare("UPDATE products SET stock = stock - ? WHERE id = ?");

        foreach ($data['items'] as $item) {
            $stmtItem->execute([$saleId, $item['productId'], $item['quantity'], $item['price']]);
            $stmtStock->execute([$item['quantity'], $item['productId']]);
        }

        $pdo->commit();
        jsonResponse(true, ['saleId' => $saleId], 'Sale completed successfully');

    } catch (Exception $e) {
        $pdo->rollBack();
        jsonResponse(false, [], $e->getMessage());
    }
}
?>