<?php
require_once 'includes/functions.php';
checkAuth();
include 'includes/header.php';
?>

<div class="dashboard-view">
    <div class="view-header">
        <h1 class="gold-gradient-text">Dashboard General</h1>
        <p>Resumen de operaciones de Urban Caps SV</p>
    </div>

    <div class="metrics-grid">
        <div class="metric-card glass-card">
            <div class="icon-box gold">
                <i data-lucide="trending-up"></i>
            </div>
            <div class="metric-info">
                <p class="label">Ventas Totales</p>
                <h2 class="value" id="totalRevenue">$0.00</h2>
            </div>
            <div class="trend pos">
                <i data-lucide="arrow-up-right" size="16"></i> +12%
            </div>
        </div>

        <div class="metric-card glass-card">
            <div class="icon-box blue">
                <i data-lucide="package"></i>
            </div>
            <div class="metric-info">
                <p class="label">Stock en Mano</p>
                <h2 class="value" id="totalStock">0</h2>
            </div>
        </div>

        <div class="metric-card glass-card">
            <div class="icon-box red">
                <i data-lucide="alert-triangle"></i>
            </div>
            <div class="metric-info">
                <p class="label">Stock Bajo</p>
                <h2 class="value" id="lowStockCount">0</h2>
            </div>
        </div>

        <div class="metric-card glass-card">
            <div class="icon-box green">
                <i data-lucide="dollar-sign"></i>
            </div>
            <div class="metric-info">
                <p class="label">Productos Activos</p>
                <h2 class="value" id="productsCount">0</h2>
            </div>
        </div>
    </div>

    <div class="charts-container">
        <div class="chart-wrapper glass-card">
            <div class="chart-header">
                <h3>Tendencia de Ventas</h3>
            </div>
            <div class="chart-body">
                <canvas id="salesChart"></canvas>
            </div>
        </div>

        <div class="recent-activity glass-card">
            <div class="chart-header">
                <h3>Alertas de Inventario</h3>
            </div>
            <div class="activity-list" id="alertsList">
                <p class="empty-msg">Cargando alertas...</p>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    document.addEventListener('DOMContentLoaded', () => {
        fetchStats();
        initChart();
    });

    async function fetchStats() {
        try {
            const response = await fetch('api/stats.php');
            const res = await response.json();

            if (res.success) {
                const data = res.data;
                document.getElementById('totalRevenue').textContent = '$' + data.totalRevenue.toFixed(2);
                document.getElementById('totalStock').textContent = data.totalStock;
                document.getElementById('lowStockCount').textContent = data.lowStockCount;
                document.getElementById('productsCount').textContent = data.productsCount;

                const alertsList = document.getElementById('alertsList');
                if (data.lowStockCount > 0) {
                    alertsList.innerHTML = `
                        <div class="alert-item warn" style="display:flex; align-items:center; gap:10px; color: var(--danger);">
                            <i data-lucide="alert-triangle"></i>
                            <div>
                                <p class="alert-title" style="font-weight:bold">¡Atención! Stock Crítico</p>
                                <p class="alert-desc">Tienes ${data.lowStockCount} productos con menos de 5 unidades.</p>
                            </div>
                        </div>
                    `;
                    lucide.createIcons();
                } else {
                    alertsList.innerHTML = '<p class="empty-msg">No hay alertas pendientes.</p>';
                }
            }
        } catch (error) {
            console.error('Error fetching stats:', error);
        }
    }

    function initChart() {
        const ctx = document.getElementById('salesChart').getContext('2d');
        new Chart(ctx, {
            type: 'line',
            data: {
                labels: ['Lun', 'Mar', 'Mie', 'Jue', 'Vie', 'Sab', 'Dom'],
                datasets: [{
                    label: 'Ventas Semanales',
                    data: [120, 190, 300, 250, 420, 580, 480],
                    fill: true,
                    backgroundColor: 'rgba(212, 175, 55, 0.1)',
                    borderColor: '#d4af37',
                    tension: 0.4
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: { legend: { display: false } },
                scales: {
                    y: {
                        grid: { color: 'rgba(255, 255, 255, 0.05)' },
                        ticks: { color: '#a0a0a0' }
                    },
                    x: {
                        grid: { display: false },
                        ticks: { color: '#a0a0a0' }
                    }
                }
            }
        });
    }
</script>

<?php include 'includes/footer.php'; ?>