<?php
require_once 'includes/functions.php';
checkAuth();
include 'includes/header.php';
?>

<div class="inventory-view">
    <div class="view-header">
        <h1 class="gold-gradient-text">Inventario</h1>
        <button class="btn-primary" onclick="openModal()">
            <i data-lucide="plus"></i> Nuevo Producto
        </button>
    </div>

    <div class="filters-bar glass-card">
        <div class="search-box">
            <i data-lucide="search" class="icon"></i>
            <input type="text" id="searchInput" placeholder="Buscar por nombre..." onkeyup="loadProducts()">
        </div>
        <select id="categoryFilter" onchange="loadProducts()">
            <option value="all">Todas las Categorías</option>
            <option value="Snapback">Snapback</option>
            <option value="Fitted">Fitted</option>
            <option value="Dad Hat">Dad Hat</option>
            <option value="Trucker">Trucker</option>
            <option value="Beanie">Beanie</option>
        </select>
    </div>

    <div class="products-grid" id="productsGrid">
        <!-- Products will be loaded here -->
    </div>
</div>

<!-- Modal -->
<div id="productModal" class="modal"
    style="display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.8); z-index:1000; justify-content:center; align-items:center;">
    <div class="modal-content glass-card" style="width:500px; padding:20px; max-height:90vh; overflow-y:auto;">
        <h2 id="modalTitle" class="gold-gradient-text" style="margin-bottom:20px;">Nuevo Producto</h2>
        <form id="productForm">
            <input type="hidden" id="productId">

            <div class="form-group" style="margin-bottom:15px;">
                <label>Nombre</label>
                <input type="text" id="name" required
                    style="width:100%; padding:10px; background:var(--black-card); border:1px solid var(--black-border); color:white; border-radius:6px;">
            </div>

            <div class="form-group" style="margin-bottom:15px;">
                <label>Precio</label>
                <input type="number" step="0.01" id="price" required
                    style="width:100%; padding:10px; background:var(--black-card); border:1px solid var(--black-border); color:white; border-radius:6px;">
            </div>

            <div class="form-group" style="margin-bottom:15px;">
                <label>Stock</label>
                <input type="number" id="stock" required
                    style="width:100%; padding:10px; background:var(--black-card); border:1px solid var(--black-border); color:white; border-radius:6px;">
            </div>

            <div class="form-group" style="margin-bottom:15px;">
                <label>Categoría</label>
                <select id="category"
                    style="width:100%; padding:10px; background:var(--black-card); border:1px solid var(--black-border); color:white; border-radius:6px;">
                    <option value="Snapback">Snapback</option>
                    <option value="Fitted">Fitted</option>
                    <option value="Dad Hat">Dad Hat</option>
                    <option value="Trucker">Trucker</option>
                    <option value="Beanie">Beanie</option>
                </select>
            </div>

            <div class="form-group" style="margin-bottom:15px;">
                <label>Imagen URL</label>
                <input type="text" id="image" placeholder="https://..."
                    style="width:100%; padding:10px; background:var(--black-card); border:1px solid var(--black-border); color:white; border-radius:6px;">
            </div>

            <div style="display:flex; justify-content:flex-end; gap:10px;">
                <button type="button" onclick="closeModal()"
                    style="padding:10px 20px; background:var(--black-border); color:white; border:none; border-radius:6px; cursor:pointer;">Cancelar</button>
                <button type="submit" class="btn-primary">Guardar</button>
            </div>
        </form>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', loadProducts);

    async function loadProducts() {
        const search = document.getElementById('searchInput').value;
        const category = document.getElementById('categoryFilter').value;
        const grid = document.getElementById('productsGrid');

        grid.innerHTML = '<p>Cargando...</p>';

        try {
            const res = await fetch(`api/products.php?search=${search}&category=${category}`);
            const result = await res.json();

            if (result.success) {
                grid.innerHTML = '';
                result.data.forEach(p => {
                    const img = p.images && p.images.length > 0 ? p.images[0] : 'assets/img/placeholder.png';
                    const card = document.createElement('div');
                    card.className = 'product-card glass-card';
                    card.innerHTML = `
                        <div class="product-image">
                            <img src="${img}" alt="${p.name}" style="width:100%; height:200px; object-fit:cover; border-radius:8px;">
                            ${p.stock < 5 ? '<span class="stock-badge low">Low Stock</span>' : ''}
                        </div>
                        <div class="product-info" style="padding:15px;">
                            <h3>${p.name}</h3>
                            <div style="display:flex; justify-content:space-between; align-items:center; margin-top:10px;">
                                <span class="price">$${parseFloat(p.price).toFixed(2)}</span>
                                <span class="stock">Stock: ${p.stock}</span>
                            </div>
                            <div class="actions" style="margin-top:15px; display:flex; gap:10px;">
                                <button onclick='editProduct(${JSON.stringify(p)})' style="padding:5px 10px; background:var(--gold-dark); border:none; border-radius:4px; cursor:pointer;">Editar</button>
                                <button onclick="deleteProduct(${p.id})" style="padding:5px 10px; background:var(--danger); border:none; border-radius:4px; cursor:pointer;">Borrar</button>
                            </div>
                        </div>
                    `;
                    grid.appendChild(card);
                });
                if (result.data.length === 0) grid.innerHTML = '<p>No se encontraron productos.</p>';
            }
        } catch (e) {
            console.error(e);
            grid.innerHTML = '<p>Error al cargar productos.</p>';
        }
    }

    const modal = document.getElementById('productModal');
    const form = document.getElementById('productForm');

    function openModal() {
        form.reset();
        document.getElementById('productId').value = '';
        document.getElementById('modalTitle').textContent = 'Nuevo Producto';
        modal.style.display = 'flex';
    }

    function closeModal() {
        modal.style.display = 'none';
    }

    window.editProduct = function (p) {
        document.getElementById('productId').value = p.id;
        document.getElementById('name').value = p.name;
        document.getElementById('price').value = p.price;
        document.getElementById('stock').value = p.stock;
        document.getElementById('category').value = p.category;
        document.getElementById('image').value = p.images && p.images.length ? p.images[0] : '';
        document.getElementById('modalTitle').textContent = 'Editar Producto';
        modal.style.display = 'flex';
    }

    window.deleteProduct = async function (id) {
        if (!confirm('¿Estás seguro de borrar este producto?')) return;

        try {
            const res = await fetch(`api/products.php?id=${id}`, { method: 'DELETE' });
            const result = await res.json();
            if (result.success) loadProducts();
            else alert(result.message);
        } catch (e) {
            alert('Error al borrar');
        }
    }

    form.addEventListener('submit', async (e) => {
        e.preventDefault();
        const id = document.getElementById('productId').value;
        const data = {
            name: document.getElementById('name').value,
            price: parseFloat(document.getElementById('price').value),
            stock: parseInt(document.getElementById('stock').value),
            category: document.getElementById('category').value,
            images: [document.getElementById('image').value]
        };

        if (id) data.id = id;

        try {
            const res = await fetch('api/products.php', {
                method: id ? 'PUT' : 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify(data)
            });
            const result = await res.json();
            if (result.success) {
                closeModal();
                loadProducts();
            } else {
                alert(result.message);
            }
        } catch (e) {
            alert('Error al guardar');
        }
    });
</script>

<?php include 'includes/footer.php'; ?>