<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Urban Caps SV</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <script src="https://unpkg.com/lucide@latest"></script>
    <style>
        /* CSS reset if not fully covered */
        body,
        html {
            margin: 0;
            padding: 0;
            min-height: 100vh;
        }

        /* Ensure React-like classes work */
        .glass-card {
            background: rgba(20, 20, 20, 0.8);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(212, 175, 55, 0.2);
            border-radius: 12px;
            box-shadow: 0 8px 32px 0 rgba(0, 0, 0, 0.37);
        }

        .gold-gradient-text {
            background: linear-gradient(45deg, #aa8928, #f9e27d);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            font-weight: bold;
        }

        /* Specific fix for login layout since react root isn't here */
        .login-container {
            height: 100vh;
            width: 100%;
            display: flex;
            justify-content: center;
            align-items: center;
            background: radial-gradient(circle at center, #1a1a1a 0%, #0a0a0a 100%);
        }
    </style>
</head>

<body>
    <div class="login-container">
        <div class="login-card glass-card">
            <div class="login-header">
                <h1 class="gold-gradient-text">URBAN CAPS SV</h1>
                <p>Sistema de Inventario & POS</p>
            </div>

            <form id="loginForm">
                <div class="input-group">
                    <i data-lucide="user" class="icon"></i>
                    <input type="text" name="username" id="username" placeholder="Usuario" required />
                </div>

                <div class="input-group">
                    <i data-lucide="lock" class="icon"></i>
                    <input type="password" name="password" id="password" placeholder="Contraseña" required />
                </div>

                <div id="error-message" class="error-message"
                    style="display:none; color: var(--danger); margin: 10px 0;"></div>

                <button type="submit" class="btn-primary" id="loginBtn">
                    Entrar
                </button>
            </form>
        </div>
    </div>

    <script>
        lucide.createIcons();

        document.getElementById('loginForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            const username = document.getElementById('username').value;
            const password = document.getElementById('password').value;
            const errorDiv = document.getElementById('error-message');
            const loginBtn = document.getElementById('loginBtn');

            loginBtn.disabled = true;
            loginBtn.textContent = 'Cargando...';
            errorDiv.style.display = 'none';

            try {
                const response = await fetch('api/login.php', {
                    method: 'POST',
                    headers: { 'Content-Type': 'application/json' },
                    body: JSON.stringify({ username, password })
                });
                const result = await response.json();

                if (result.success) {
                    window.location.href = 'dashboard.php';
                } else {
                    errorDiv.textContent = result.message || 'Error de autenticación';
                    errorDiv.style.display = 'block';
                    loginBtn.disabled = false;
                    loginBtn.textContent = 'Entrar';
                }
            } catch (err) {
                errorDiv.textContent = 'Error de conexión';
                errorDiv.style.display = 'block';
                loginBtn.disabled = false;
                loginBtn.textContent = 'Entrar';
            }
        });
    </script>
</body>

</html>