<?php
require_once 'includes/functions.php';
checkAuth();
include 'includes/header.php';
?>

<div class="pos-layout" style="display: flex; height: calc(100vh - 80px); gap: 20px;">
    <!-- Products Section -->
    <div class="products-section" style="flex: 2; display: flex; flex-direction: column;">
        <div class="search-bar glass-card" style="padding: 15px; margin-bottom: 20px;">
            <input type="text" id="posSearch" placeholder="Buscar producto..."
                style="width: 100%; padding: 10px; border-radius: 8px; border: 1px solid var(--black-border); background: var(--black-bg); color: white;"
                onkeyup="loadPosProducts()">
        </div>

        <div class="products-grid-scroll" id="posProductsGrid"
            style="flex: 1; overflow-y: auto; display: grid; grid-template-columns: repeat(auto-fill, minmax(150px, 1fr)); gap: 15px;">
            <!-- Products loaded here -->
        </div>
    </div>

    <!-- Cart Section -->
    <div class="cart-section glass-card" style="flex: 1; display: flex; flex-direction: column; padding: 20px;">
        <h2 class="gold-gradient-text">Carrito</h2>
        <div class="cart-items" id="cartItems" style="flex: 1; overflow-y: auto; margin-top: 15px;">
            <!-- Cart Items -->
            <p class="empty-msg">Carrito vacío</p>
        </div>

        <div class="cart-summary" style="border-top: 1px solid var(--glass-border); padding-top: 15px;">
            <div
                style="display: flex; justify-content: space-between; font-size: 1.2em; font-weight: bold; margin-bottom: 15px;">
                <span>Total:</span>
                <span id="cartTotal">$0.00</span>
            </div>

            <select id="paymentMethod"
                style="width: 100%; padding: 10px; margin-bottom: 15px; background: var(--black-bg); color: white; border: 1px solid var(--black-border); border-radius: 6px;">
                <option value="EFECTIVO">Efectivo</option>
                <option value="TRANSFERENCIA">Transferencia</option>
                <option value="TARJETA">Tarjeta</option>
            </select>

            <button class="btn-primary" style="width: 100%;" onclick="processSale()">Confirmar Venta</button>
        </div>
    </div>
</div>

<script>
    let cart = [];

    document.addEventListener('DOMContentLoaded', loadPosProducts);

    async function loadPosProducts() {
        const search = document.getElementById('posSearch').value;
        const grid = document.getElementById('posProductsGrid');

        try {
            const res = await fetch(`api/products.php?search=${search}`);
            const result = await res.json();

            if (result.success) {
                grid.innerHTML = '';
                result.data.forEach(p => {
                    const img = p.images && p.images.length > 0 ? p.images[0] : 'assets/img/placeholder.png';
                    const card = document.createElement('div');
                    card.className = 'product-card glass-card';
                    card.style.cursor = 'pointer';
                    card.onclick = () => addToCart(p);
                    card.innerHTML = `
                        <div style="position: relative;">
                            <img src="${img}" style="width: 100%; height: 120px; object-fit: cover; border-radius: 8px;">
                            ${p.stock < 1 ? '<div style="position: absolute; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.7); display:flex; align-items:center; justify-content:center; color:red; font-weight:bold;">Agotado</div>' : ''}
                        </div>
                        <div style="padding: 10px;">
                            <h4 style="font-size: 0.9em; margin-bottom: 5px;">${p.name}</h4>
                            <div style="display: flex; justify-content: space-between;">
                                <span class="price">$${parseFloat(p.price).toFixed(2)}</span>
                                <span style="font-size: 0.8em; color: var(--text-secondary);">Stock: ${p.stock}</span>
                            </div>
                        </div>
                    `;
                    grid.appendChild(card);
                });
            }
        } catch (e) {
            console.error(e);
        }
    }

    function addToCart(product) {
        if (product.stock < 1) return;

        const existing = cart.find(item => item.product.id === product.id);
        if (existing) {
            if (existing.quantity < product.stock) {
                existing.quantity++;
            } else {
                alert('No hay más stock disponible');
            }
        } else {
            cart.push({ product: product, quantity: 1 });
        }
        renderCart();
    }

    function removeFromCart(index) {
        cart.splice(index, 1);
        renderCart();
    }

    function updateQuantity(index, delta) {
        const item = cart[index];
        const newQty = item.quantity + delta;
        if (newQty > 0 && newQty <= item.product.stock) {
            item.quantity = newQty;
        }
        renderCart();
    }

    function renderCart() {
        const container = document.getElementById('cartItems');
        if (cart.length === 0) {
            container.innerHTML = '<p class="empty-msg">Carrito vacío</p>';
            document.getElementById('cartTotal').textContent = '$0.00';
            return;
        }

        container.innerHTML = '';
        let total = 0;

        cart.forEach((item, index) => {
            const itemTotal = item.product.price * item.quantity;
            total += itemTotal;

            const div = document.createElement('div');
            div.className = 'cart-item glass-card';
            div.style.padding = '10px';
            div.style.marginBottom = '10px';
            div.style.display = 'flex';
            div.style.justifyContent = 'space-between';
            div.style.alignItems = 'center';

            div.innerHTML = `
                <div>
                    <div style="font-weight: bold;">${item.product.name}</div>
                    <div style="font-size: 0.8em; color: var(--text-secondary);">$${parseFloat(item.product.price).toFixed(2)} x ${item.quantity}</div>
                </div>
                <div style="display: flex; align-items: center; gap: 5px;">
                    <button onclick="updateQuantity(${index}, -1)" style="padding: 2px 8px; background: var(--black-border); border: none; color: white;">-</button>
                    <span>${item.quantity}</span>
                    <button onclick="updateQuantity(${index}, 1)" style="padding: 2px 8px; background: var(--black-border); border: none; color: white;">+</button>
                    <button onclick="removeFromCart(${index})" style="margin-left: 5px; color: var(--danger); background: none; border: none;"><i data-lucide="trash-2" size="16"></i></button>
                </div>
            `;
            container.appendChild(div);
        });

        document.getElementById('cartTotal').textContent = '$' + total.toFixed(2);
        lucide.createIcons();
    }

    async function processSale() {
        if (cart.length === 0) return alert('El carrito está vacío');

        if (!confirm('¿Confirmar venta?')) return;

        const items = cart.map(item => ({
            productId: item.product.id,
            quantity: item.quantity,
            price: item.product.price
        }));

        const paymentMethod = document.getElementById('paymentMethod').value;

        try {
            const res = await fetch('api/sales.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({ items, paymentMethod })
            });
            const result = await res.json();

            if (result.success) {
                alert('Venta realizada con éxito');
                cart = [];
                renderCart();
                loadPosProducts(); // Refresh stock
            } else {
                alert('Error: ' + result.message);
            }
        } catch (e) {
            alert('Error de conexión');
        }
    }
</script>

<?php include 'includes/footer.php'; ?>